package kochModel;
import lrs.*;
import java.awt.*;

import kochModel.*;
import fp.*;

/**
 * The non-base case state of the Koch curve.   This state is just a wrapper around a list of Koch curves that supplies the required
 * paint and grow methods.   These methods are recursively applied to the  list of Koch curves held.
 */
class InductState extends AKochState
{
  
  /**
   * The list of Koch curves.
   */
  private LRStruct<Koch> kochList = new LRStruct<Koch>();
  
  /**
   * Constructor for this state, not publicly accessible.
   * All this constructor does is to initialize the list of Kochs being held.
   * @param kochList A list of  Koch curves to attach as those being held.
   */
  InductState(LRStruct<Koch> kochList)  {  
    this.kochList = kochList;
  }
  
  
  public <R, P> R execute(Koch host, IKochVisitor<R,P> algo, P...param) {
    return algo.inductCase(host, param);
  }
  
  public <P> void map(final Koch host, final IMapAlgo<Koch,P> algo, final P... inp) {
    IAlgo<Koch,Object,P> _lrsAlgo = new IAlgo<Koch, Object, P>() {
      public Object emptyCase(LRStruct<? extends Koch> host1, P... inp2) {
        return null;
      }
      public Object nonEmptyCase(LRStruct<? extends Koch> host1, P... inp2) {
        if (algo.apply(host1.getFirst(), inp))
          return host1.getRest().execute(this);
        else
          return null;
      }
    };
    kochList.execute(_lrsAlgo);
  }

}

